/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.service.internal;

import java.util.Collections;
import java.util.List;

public interface ICommonBackupWorker {

	default List<MailboxIndexJson> partitionTreatment(String domainUid, String zipHash, List<String> partition) {
		return Collections.emptyList();
	}

	void logError(Throwable throwable);

	void logError(Exception ex, String message, Object... args);

	void logError(String message, Object... args);

}
