<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * SubscriptionInformations.
 */
class SubscriptionInformations  {

  /*
   * @type String
   */
  public $version;

  /*
   * @type String
   */
  public $installationVersion;

  /*
   * @type String
   */
  public $customer;

  /*
   * @type String
   */
  public $customerCode;

  /*
   * @type String
   */
  public $dealer;

  /*
   * @type String
   */
  public $distributor;

  /*
   * @type SubscriptionInformationsKind
   */
  public $kind;

  /*
   * @type javautilDate
   */
  public $starts;

  /*
   * @type javautilDate
   */
  public $ends;

  /*
   * @type boolean
   */
  public $valid;

  /*
   * @type String
   */
  public $pubKeyFingerprint;

  /*
   * @type boolean
   */
  public $validProvider;

  /*
   * @type String
   */
  public $fromTechVersion;

  /*
   * @type List
   */
  public $indicator;

  /*
   * @type List
   */
  public $contacts;

  /*
   * @type List
   */
  public $messages;

  /*
   * Constructor
   */
  public function __construct() {
    $this->version = "";
    $this->installationVersion = "";
    $this->customer = "";
    $this->customerCode = "";
    $this->dealer = "";
    $this->distributor = "";
    $this->starts = null;
    $this->ends = null;
    $this->valid = false;
    $this->pubKeyFingerprint = "";
    $this->validProvider = false;
    $this->fromTechVersion = "";
    $this->indicator =  array();
    $this->contacts =  array();
    $this->messages =  array();
  }

  public function toMap() {
    $data = array(    
        "version" => empty($this->version) ? null : $this->version,    
        "installationVersion" => empty($this->installationVersion) ? null : $this->installationVersion,    
        "customer" => empty($this->customer) ? null : $this->customer,    
        "customerCode" => empty($this->customerCode) ? null : $this->customerCode,    
        "dealer" => empty($this->dealer) ? null : $this->dealer,    
        "distributor" => empty($this->distributor) ? null : $this->distributor,    
        "kind" => empty($this->kind) ? null : $this->kind,    
        "starts" => empty($this->starts) ? null : $this->starts,    
        "ends" => empty($this->ends) ? null : $this->ends,    
        "valid" => empty($this->valid) ? null : $this->valid,    
        "pubKeyFingerprint" => empty($this->pubKeyFingerprint) ? null : $this->pubKeyFingerprint,    
        "validProvider" => empty($this->validProvider) ? null : $this->validProvider,    
        "fromTechVersion" => empty($this->fromTechVersion) ? null : $this->fromTechVersion,    
        "indicator" => empty($this->indicator) ? null : $this->indicator,    
        "contacts" => empty($this->contacts) ? null : $this->contacts,    
        "messages" => empty($this->messages) ? null : $this->messages);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
