/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.directory.repository;

import java.util.List;
import java.util.Set;

import net.bluemind.core.container.model.Item;
import net.bluemind.core.container.repository.IItemValueStore;
import net.bluemind.directory.api.BaseDirEntry.Kind;

public interface IDirEntryStore extends IItemValueStore<DirEntryNG> {

	public record ItemIdAndRole(long itemId, Set<String> roles) {

	}

	Item byMailboxName(String mailboxName);

	Item byEmail(String email);

	List<ItemIdAndRole> byKind(Kind k);

	void addMemberOf(Item deItem, String groupUid);

	void rmMemberOf(Item deItem, String groupUid);

}
