/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.directory.service.internal.cql;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import net.bluemind.core.container.api.ItemValueExists;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.rest.BmContext;
import net.bluemind.directory.api.IOrgUnits;
import net.bluemind.directory.api.OrgUnit;
import net.bluemind.directory.api.OrgUnitPath;
import net.bluemind.directory.api.OrgUnitQuery;
import net.bluemind.directory.cql.common.CqlContStoreService;
import net.bluemind.domain.api.Domain;

public class CqlOrgUnits implements IOrgUnits {

	private final CqlContStoreService store;
	private final ItemValue<Domain> domain;

	public CqlOrgUnits(BmContext context, Container container, ItemValue<Domain> domainValue) {
		this.store = new CqlContStoreService(context, container, domainValue);
		this.domain = domainValue;
	}

	@Override
	public OrgUnit get(String uid) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void restore(ItemValue<OrgUnit> item, boolean isCreate) {
		// TODO Auto-generated method stub

	}

	@Override
	public ItemValueExists itemValueExists(String uid) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ItemValue<OrgUnit> getComplete(String uid) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<ItemValue<OrgUnit>> getChildren(String uid) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void create(String uid, OrgUnit value) {
		// TODO Auto-generated method stub

	}

	@Override
	public void update(String uid, OrgUnit value) {
		// TODO Auto-generated method stub

	}

	@Override
	public void delete(String uid) {
		// TODO Auto-generated method stub

	}

	@Override
	public OrgUnitPath getPath(String uid) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<OrgUnitPath> search(OrgUnitQuery query) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setAdministratorRoles(String orgUnitUid, String dirEntryUid, Set<String> roles) {
		// TODO Auto-generated method stub

	}

	@Override
	public Set<String> getAdministratorRoles(String orgUnitUid, String dirEntryUid, List<String> groups) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Set<String> getAdministrators(String uid, boolean hierarchical) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<OrgUnitPath> listByAdministrator(String administrator, List<String> groups) {
		System.err.println("listByAdmin(" + administrator + ", " + groups + ")");
		// TODO Auto-generated method stub
		return Collections.emptyList();
	}

	@Override
	public void removeAdministrator(String administrator) {
		// TODO Auto-generated method stub

	}

}
