/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2023
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.directory.service.internal;

import net.bluemind.core.auditlogs.AuditLogUpdateStatus;
import net.bluemind.core.auditlogs.AuditLogUpdateStatus.MessageCriticity;
import net.bluemind.core.auditlogs.ContentElement;
import net.bluemind.core.auditlogs.ContentElement.ContentElementBuilder;
import net.bluemind.core.container.model.ChangeLogEntry.Type;
import net.bluemind.directory.api.OrgUnit;
import net.bluemind.directory.service.AuditLogDirEntryMapper;
import net.bluemind.directory.service.DirEntryAndValue;

public class AuditLogDirEntryOrgUnitMapper extends AuditLogDirEntryMapper<OrgUnit> {

	@Override
	public ContentElement createContentElement(DirEntryAndValue<OrgUnit> dirEntryAndValue, Type type) {
		ContentElementBuilder builder = super.createContentElementBuilder(dirEntryAndValue);
		return builder.build();
	}

	@Override
	public AuditLogUpdateStatus createUpdateMessage(DirEntryAndValue<OrgUnit> oldValue,
			DirEntryAndValue<OrgUnit> newValue) throws Exception {
		StringBuilder sBuilder = new StringBuilder();
		AuditLogUpdateStatus auditLogUpdateStatus = new AuditLogUpdateStatus();
		if (!oldValue.entry.displayName.equals(newValue.entry.displayName)) {
			sBuilder.append("Changed displayname: '" + oldValue.entry.displayName + "' -> '"
					+ newValue.entry.displayName + "'" + CRLF);
		}

		String updateMessage = sBuilder.toString();
		auditLogUpdateStatus.updateMessage = updateMessage;

		if (updateMessage.isBlank()) {
			auditLogUpdateStatus.crit = MessageCriticity.MINOR;
		}
		return auditLogUpdateStatus;
	}

}
