/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.scheduledjob.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsJobExitStatus extends JavaScriptObject {

	protected JsJobExitStatus() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsJobExitStatus IN_PROGRESS()
	/*-{
		return "IN_PROGRESS";
	}-*/;

	public static final native JsJobExitStatus SUCCESS()
	/*-{
		return "SUCCESS";
	}-*/;

	public static final native JsJobExitStatus COMPLETED_WITH_WARNINGS()
	/*-{
		return "COMPLETED_WITH_WARNINGS";
	}-*/;

	public static final native JsJobExitStatus FAILURE()
	/*-{
		return "FAILURE";
	}-*/;

	public static final native JsJobExitStatus UNKNOWN()
	/*-{
		return "UNKNOWN";
	}-*/;

	public static final native JsJobExitStatus INTERRUPTED()
	/*-{
		return "INTERRUPTED";
	}-*/;

	public static final JsJobExitStatus create(net.bluemind.scheduledjob.api.JobExitStatus value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case IN_PROGRESS:
				return IN_PROGRESS();
			case SUCCESS:
				return SUCCESS();
			case COMPLETED_WITH_WARNINGS:
				return COMPLETED_WITH_WARNINGS();
			case FAILURE:
				return FAILURE();
			case UNKNOWN:
				return UNKNOWN();
			case INTERRUPTED:
				return INTERRUPTED();
			default:
				return null;
			}
		}
	}
}