<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * SharedContainer.
 */
class SharedContainer  {

  /*
   * @type BaseContainerDescriptor
   */
  public $shared;

  /*
   * @type Set
   */
  public $givenRights;

  /*
   * Constructor
   */
  public function __construct() {
    $this->shared =   new BaseContainerDescriptor();
    $this->givenRights = array();
  }

  public function toMap() {
    $data = array(    
        "shared" => empty($this->shared) ? null : $this->shared,    
        "givenRights" => empty($this->givenRights) ? null : $this->givenRights);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
