<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ItemFlagFilter.
 */
class ItemFlagFilter  {

  /*
   * @type Collection
   */
  public $must;

  /*
   * @type Collection
   */
  public $mustNot;

  /*
   * @type Set
   */
  public $skipVersions;

  /*
   * @type boolean
   */
  public $skipExpunged;

  /*
   * Constructor
   */
  public function __construct() {
    $this->must =   new Collection();
    $this->mustNot =   new Collection();
    $this->skipVersions = array();
    $this->skipExpunged = false;
  }

  public function toMap() {
    $data = array(    
        "must" => empty($this->must) ? null : $this->must,    
        "mustNot" => empty($this->mustNot) ? null : $this->mustNot,    
        "skipVersions" => empty($this->skipVersions) ? null : $this->skipVersions,    
        "skipExpunged" => empty($this->skipExpunged) ? null : $this->skipExpunged);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
