/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailmessage.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MessageContextGwtSerDer implements GwtSerDer<net.bluemind.mailmessage.api.MessageContext> {

	public MessageContextGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailmessage.api.MessageContext deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailmessage.api.MessageContext ret = new net.bluemind.mailmessage.api.MessageContext();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailmessage.api.MessageContext ret, JSONObject json) {
		JSONValue fromIdentityJSON = json.get("fromIdentity");
		ret.fromIdentity =  new net.bluemind.mailflow.common.api.gwt.serder.SendingAsGwtSerDer().deserialize(fromIdentityJSON);
		JSONValue recipientsJSON = json.get("recipients");
		ret.recipients =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailflow.common.api.gwt.serder.RecipientGwtSerDer()).deserialize(recipientsJSON);
		JSONValue messageClassJSON = json.get("messageClass");
		ret.messageClass =  GwtSerDerUtils.STRING.deserialize(messageClassJSON);
		JSONValue subjectJSON = json.get("subject");
		ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
	}

	public void deserializeTo(net.bluemind.mailmessage.api.MessageContext ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("fromIdentity")) {
			JSONValue fromIdentityJSON = json.get("fromIdentity");
			ret.fromIdentity =  new net.bluemind.mailflow.common.api.gwt.serder.SendingAsGwtSerDer().deserialize(fromIdentityJSON);
		}
		if (!childPropertiesToIgnore.contains("recipients")) {
			JSONValue recipientsJSON = json.get("recipients");
			ret.recipients =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailflow.common.api.gwt.serder.RecipientGwtSerDer()).deserialize(recipientsJSON);
		}
		if (!childPropertiesToIgnore.contains("messageClass")) {
			JSONValue messageClassJSON = json.get("messageClass");
			ret.messageClass =  GwtSerDerUtils.STRING.deserialize(messageClassJSON);
		}
		if (!childPropertiesToIgnore.contains("subject")) {
			JSONValue subjectJSON = json.get("subject");
			ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailmessage.api.MessageContext o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailmessage.api.MessageContext o, JSONObject ret) {

		ret.put("fromIdentity",  new net.bluemind.mailflow.common.api.gwt.serder.SendingAsGwtSerDer().serialize( o.fromIdentity ));
		ret.put("recipients",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailflow.common.api.gwt.serder.RecipientGwtSerDer()).serialize( o.recipients ));
		ret.put("messageClass",  GwtSerDerUtils.STRING.serialize( o.messageClass ));
		ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
	}

	public void serializeTo(net.bluemind.mailmessage.api.MessageContext o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("fromIdentity")) {
			ret.put("fromIdentity",  new net.bluemind.mailflow.common.api.gwt.serder.SendingAsGwtSerDer().serialize( o.fromIdentity ));
		}
		if (!childPropertiesToIgnore.contains("recipients")) {
			ret.put("recipients",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailflow.common.api.gwt.serder.RecipientGwtSerDer()).serialize( o.recipients ));
		}
		if (!childPropertiesToIgnore.contains("messageClass")) {
			ret.put("messageClass",  GwtSerDerUtils.STRING.serialize( o.messageClass ));
		}
		if (!childPropertiesToIgnore.contains("subject")) {
			ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}