/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.user.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class UserAccountInfoGwtSerDer implements GwtSerDer<net.bluemind.user.api.UserAccountInfo> {

	private net.bluemind.user.api.gwt.serder.UserAccountGwtSerDer parent = new  net.bluemind.user.api.gwt.serder.UserAccountGwtSerDer();
	public UserAccountInfoGwtSerDer( ) {
	}

	@Override
	public net.bluemind.user.api.UserAccountInfo deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.user.api.UserAccountInfo ret = new net.bluemind.user.api.UserAccountInfo();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.user.api.UserAccountInfo ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue externalSystemIdJSON = json.get("externalSystemId");
		ret.externalSystemId =  GwtSerDerUtils.STRING.deserialize(externalSystemIdJSON);
	}

	public void deserializeTo(net.bluemind.user.api.UserAccountInfo ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("externalSystemId")) {
			JSONValue externalSystemIdJSON = json.get("externalSystemId");
			ret.externalSystemId =  GwtSerDerUtils.STRING.deserialize(externalSystemIdJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.user.api.UserAccountInfo o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.user.api.UserAccountInfo o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("externalSystemId",  GwtSerDerUtils.STRING.serialize( o.externalSystemId ));
	}

	public void serializeTo(net.bluemind.user.api.UserAccountInfo o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("externalSystemId")) {
			ret.put("externalSystemId",  GwtSerDerUtils.STRING.serialize( o.externalSystemId ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}