/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.server.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class CommandStatusGwtSerDer implements GwtSerDer<net.bluemind.server.api.CommandStatus> {

	public CommandStatusGwtSerDer( ) {
	}

	@Override
	public net.bluemind.server.api.CommandStatus deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.server.api.CommandStatus ret = new net.bluemind.server.api.CommandStatus();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.server.api.CommandStatus ret, JSONObject json) {
		JSONValue completeJSON = json.get("complete");
		ret.complete =  GwtSerDerUtils.BOOLEAN.deserialize(completeJSON);
		JSONValue successfulJSON = json.get("successful");
		ret.successful =  GwtSerDerUtils.BOOLEAN.deserialize(successfulJSON);
		JSONValue outputJSON = json.get("output");
		ret.output =  new GwtSerDerUtils.CollectionSerDer<>(GwtSerDerUtils.STRING).deserialize(outputJSON);
	}

	public void deserializeTo(net.bluemind.server.api.CommandStatus ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("complete")) {
			JSONValue completeJSON = json.get("complete");
			ret.complete =  GwtSerDerUtils.BOOLEAN.deserialize(completeJSON);
		}
		if (!childPropertiesToIgnore.contains("successful")) {
			JSONValue successfulJSON = json.get("successful");
			ret.successful =  GwtSerDerUtils.BOOLEAN.deserialize(successfulJSON);
		}
		if (!childPropertiesToIgnore.contains("output")) {
			JSONValue outputJSON = json.get("output");
			ret.output =  new GwtSerDerUtils.CollectionSerDer<>(GwtSerDerUtils.STRING).deserialize(outputJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.server.api.CommandStatus o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.server.api.CommandStatus o, JSONObject ret) {

		ret.put("complete",  GwtSerDerUtils.BOOLEAN.serialize( o.complete ));
		ret.put("successful",  GwtSerDerUtils.BOOLEAN.serialize( o.successful ));
		ret.put("output",  new GwtSerDerUtils.CollectionSerDer<>(GwtSerDerUtils.STRING).serialize( o.output ));
	}

	public void serializeTo(net.bluemind.server.api.CommandStatus o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("complete")) {
			ret.put("complete",  GwtSerDerUtils.BOOLEAN.serialize( o.complete ));
		}
		if (!childPropertiesToIgnore.contains("successful")) {
			ret.put("successful",  GwtSerDerUtils.BOOLEAN.serialize( o.successful ));
		}
		if (!childPropertiesToIgnore.contains("output")) {
			ret.put("output",  new GwtSerDerUtils.CollectionSerDer<>(GwtSerDerUtils.STRING).serialize( o.output ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}