/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.server.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class ServerEndpointPromise implements net.bluemind.server.api.IServerPromise {

	private net.bluemind.server.api.IServerAsync impl;

	public ServerEndpointPromise(net.bluemind.server.api.IServerAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>>> allComplete() {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.allComplete( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> assign(String serverUid ,  String domainUid ,  String tag  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.assign(serverUid, domainUid, tag,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> byAssignment(String domainUid ,  String tag  ) {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byAssignment(domainUid, tag,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> create(String uid ,  net.bluemind.server.api.Server srv  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, srv,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.server.api.Assignment>> getAssignments(String domainUid  ) {
		
		CompletableFuture<List<net.bluemind.server.api.Assignment>> ret = new CompletableFuture<List<net.bluemind.server.api.Assignment>>();
		AsyncHandler<List<net.bluemind.server.api.Assignment>> handler = new AsyncHandler<List<net.bluemind.server.api.Assignment>>() {
			public void success(List<net.bluemind.server.api.Assignment> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getAssignments(domainUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.server.api.Assignment>> getServerAssignments(String uid  ) {
		
		CompletableFuture<List<net.bluemind.server.api.Assignment>> ret = new CompletableFuture<List<net.bluemind.server.api.Assignment>>();
		AsyncHandler<List<net.bluemind.server.api.Assignment>> handler = new AsyncHandler<List<net.bluemind.server.api.Assignment>>() {
			public void success(List<net.bluemind.server.api.Assignment> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getServerAssignments(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.server.api.CommandStatus> getStatus(String uid ,  String ref  ) {
		
		CompletableFuture<net.bluemind.server.api.CommandStatus> ret = new CompletableFuture<net.bluemind.server.api.CommandStatus>();
		AsyncHandler<net.bluemind.server.api.CommandStatus> handler = new AsyncHandler<net.bluemind.server.api.CommandStatus>() {
			public void success(net.bluemind.server.api.CommandStatus value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getStatus(uid, ref,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<byte[]> readFile(String uid ,  String path  ) {
		
		CompletableFuture<byte[]> ret = new CompletableFuture<byte[]>();
		AsyncHandler<byte[]> handler = new AsyncHandler<byte[]>() {
			public void success(byte[] value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.readFile(uid, path,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> setTags(String uid ,  List<String> tags  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setTags(uid, tags,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<String> submit(String uid ,  String[] argv  ) {
		
		CompletableFuture<String> ret = new CompletableFuture<String>();
		AsyncHandler<String> handler = new AsyncHandler<String>() {
			public void success(String value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.submit(uid, argv,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.server.api.CommandStatus> submitAndWait(String uid ,  String[] argv  ) {
		
		CompletableFuture<net.bluemind.server.api.CommandStatus> ret = new CompletableFuture<net.bluemind.server.api.CommandStatus>();
		AsyncHandler<net.bluemind.server.api.CommandStatus> handler = new AsyncHandler<net.bluemind.server.api.CommandStatus>() {
			public void success(net.bluemind.server.api.CommandStatus value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.submitAndWait(uid, argv,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> unassign(String serverUid ,  String domainUid ,  String tag  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.unassign(serverUid, domainUid, tag,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> update(String uid ,  net.bluemind.server.api.Server srv  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, srv,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> writeFile(String uid ,  String path ,  byte[] content  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.writeFile(uid, path, content,  handler);
		return ret;
	}

}
