import { createApp } from "vue";
import i18n from "@bluemind/i18n";
import store from "@bluemind/store";

export default {
    methods: {
        print(vnode) {
            const app = createApp(vnode);
            app.use(i18n);
            app.use(store);

            const appComponents = this.$.appContext.components;
            for (const name in appComponents) {
                app.component(name, appComponents[name]);
            }

            const iframe = document.createElement("iframe");
            iframe.srcdoc = `<html><head><base href="${document.baseURI}"/></head></html>`;
            iframe.style.width = "0";
            iframe.style.height = "0";
            iframe.addEventListener("load", () => {
                app.mount(iframe.contentDocument.body);
                iframe.contentWindow.addEventListener("afterprint", () => {
                    app.onUnmount(() => document.body.removeChild(iframe));
                    app.unmount();
                });
                setTimeout(() => iframe.contentWindow.print(), 350);
            });

            document.body.appendChild(iframe);
        }
    }
};
