import { mapState } from "vuex";
import { messageUtils } from "@bluemind/mail";
import NotifyOrganizerAlert from "./NotifyOrganizerAlert.vue";
import { AlertTypes, useDispatchAlert } from "@bluemind/bluetiful";
import { markRaw } from "vue";
const { hasCalendarPart, MessageHeader } = messageUtils;

export default {
    setup() {
        const { dispatchAlert, removeAlert } = useDispatchAlert();
        return { dispatchAlert, removeAlert };
    },
    props: {
        message: {
            type: Object,
            required: true
        }
    },
    computed: {
        ...mapState("mail", {
            organizer: ({ consultPanel }) => consultPanel.currentEvent?.serverEvent?.value?.main?.organizer
        }),
        hasEventForward() {
            const isForward =
                this.message.headers.find(header => header.name === MessageHeader.REFERENCES) &&
                this.message.from.address !== this.organizer?.mail;
            return isForward && hasCalendarPart(this.message.structure);
        },
        alert() {
            return {
                uid: `MESSAGE_NOTIFY_ORGANIZER_${this.message.key}`,
                renderer: {
                    component: markRaw(NotifyOrganizerAlert),
                    props: {
                        alert: {
                            payload: this.organizer?.commonName
                        }
                    }
                },
                type: AlertTypes.INFO
            };
        }
    },
    watch: {
        organizer: {
            async handler() {
                if (this.hasEventForward && this.organizer) {
                    await this.dispatchAlert(this.alert);
                } else {
                    this.removeAlert(this.alert);
                }
            },
            immediate: true
        }
    },
    unmounted() {
        this.removeAlert(this.alert);
    },
    render() {
        return "";
    }
};
