package net.bluemind.ui.gwtrole.client;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

import net.bluemind.role.api.BasicRoles;
import net.bluemind.ui.common.client.SizeHint;
import net.bluemind.ui.gwtrole.client.i18n.RolesConstants;

public class SystemManagementWarningPanel extends Composite {

	public static final Set<String> DEFAULT_APP_ROLES = new HashSet<>(
			Arrays.asList(BasicRoles.ROLE_MAIL, BasicRoles.ROLE_CALENDAR, BasicRoles.ROLE_EAS, BasicRoles.ROLE_DAV,
					BasicRoles.ROLE_TBIRD, BasicRoles.ROLE_OUTLOOK, BasicRoles.ROLE_CTI, BasicRoles.ROLE_MAIL_WEBAPP));

	private DialogBox os;
	private String warningMessage;

	public SystemManagementWarningPanel() {

		VerticalPanel vp = new VerticalPanel();
		Label label = new Label(warningMessage);
		label.getElement().getStyle().setPadding(5, Unit.PX);
		label.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
		vp.add(label);
		Button button = new Button(RolesConstants.INST.messageIUnderstand());
		button.addStyleName("button");
		button.addStyleName("primary");
		button.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				os.hide();
			}
		});
		vp.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
		vp.add(button);
		initWidget(vp);
	}

	public SizeHint getSizeHint() {
		return new SizeHint(700, 50);

	}

	public void setOverlay(DialogBox os) {
		this.os = os;
	}

	public boolean checkRolesAreCompatible(Set<String> allRoles) {
		return !(checkHasRoleSystemManagement(allRoles) && checkHasAppRoles(allRoles));
	}

	public void setWarningMessage(String msg) {
		this.warningMessage = msg;
		VerticalPanel vp = (VerticalPanel) getWidget();

		Iterator<Widget> vPanelWidgets = vp.iterator();
		while (vPanelWidgets.hasNext()) {
			Widget childWidget = vPanelWidgets.next();
			if (childWidget instanceof Label) {
				Label label = (Label) childWidget;
				label.setText(msg);
			}
		}
	}

	private boolean checkHasRoleSystemManagement(Set<String> roles) {
		return roles.contains(BasicRoles.ROLE_SYSTEM_MANAGER);
	}

	private boolean checkHasAppRoles(Set<String> roles) {
		for (String role : roles) {
			if (DEFAULT_APP_ROLES.contains(role)) {
				return true;
			}
		}
		return false;
	}

}
