/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.globalsettings.cql.store;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.cql.persistence.CqlAbstractStore;
import net.bluemind.globalsettings.repository.IGlobalSettingsStore;

public class CqlGlobalSettingsStore extends CqlAbstractStore implements IGlobalSettingsStore {

	public CqlGlobalSettingsStore(CqlSession s) {
		super(s);
	}

	@Override
	public Map<String, String> get() throws SQLException {
		return Optional
				.ofNullable(unique("SELECT settings FROM t_settings_global WHERE settings_id=?",
						r -> r.getMap(0, String.class, String.class), voidPop(), IGlobalSettingsStore.GLOBAL_ID))
				.orElse(Collections.emptyMap());
	}

	@Override
	public void set(Map<String, String> values) throws SQLException {
		voidCql("UPDATE t_settings_global SET settings = settings + ? WHERE settings_id=?", values,
				IGlobalSettingsStore.GLOBAL_ID);
	}

}
