<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * Device.
 */
class Device  {

  /*
   * @type String
   */
  public $identifier;

  /*
   * @type String
   */
  public $owner;

  /*
   * @type String
   */
  public $type;

  /*
   * @type javautilDate
   */
  public $wipeDate;

  /*
   * @type String
   */
  public $wipeBy;

  /*
   * @type javautilDate
   */
  public $unwipeDate;

  /*
   * @type String
   */
  public $unwipeBy;

  /*
   * @type boolean
   */
  public $isWiped;

  /*
   * @type WipeMode
   */
  public $wipeMode;

  /*
   * @type boolean
   */
  public $hasPartnership;

  /*
   * @type Integer
   */
  public $policy;

  /*
   * @type javautilDate
   */
  public $lastSync;

  /*
   * @type double
   */
  public $protocolVersion;

  /*
   * Constructor
   */
  public function __construct() {
    $this->identifier = "";
    $this->owner = "";
    $this->type = "";
    $this->wipeDate = null;
    $this->wipeBy = "";
    $this->unwipeDate = null;
    $this->unwipeBy = "";
    $this->isWiped = false;
    $this->hasPartnership = false;
    $this->policy = null;
    $this->lastSync = null;
    $this->protocolVersion = 0;
  }

  public function toMap() {
    $data = array(    
        "identifier" => empty($this->identifier) ? null : $this->identifier,    
        "owner" => empty($this->owner) ? null : $this->owner,    
        "type" => empty($this->type) ? null : $this->type,    
        "wipeDate" => empty($this->wipeDate) ? null : $this->wipeDate,    
        "wipeBy" => empty($this->wipeBy) ? null : $this->wipeBy,    
        "unwipeDate" => empty($this->unwipeDate) ? null : $this->unwipeDate,    
        "unwipeBy" => empty($this->unwipeBy) ? null : $this->unwipeBy,    
        "isWiped" => empty($this->isWiped) ? null : $this->isWiped,    
        "wipeMode" => empty($this->wipeMode) ? null : $this->wipeMode,    
        "hasPartnership" => empty($this->hasPartnership) ? null : $this->hasPartnership,    
        "policy" => empty($this->policy) ? null : $this->policy,    
        "lastSync" => empty($this->lastSync) ? null : $this->lastSync,    
        "protocolVersion" => empty($this->protocolVersion) ? null : $this->protocolVersion);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
