/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.cti.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class StatusGwtSerDer implements GwtSerDer<net.bluemind.cti.api.Status> {

	public StatusGwtSerDer( ) {
	}

	@Override
	public net.bluemind.cti.api.Status deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.cti.api.Status ret = new net.bluemind.cti.api.Status();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.cti.api.Status ret, JSONObject json) {
		JSONValue typeJSON = json.get("type");
		ret.type =  new net.bluemind.cti.api.gwt.serder.StatusTypeGwtSerDer().deserialize(typeJSON);
		JSONValue messageJSON = json.get("message");
		ret.message =  GwtSerDerUtils.STRING.deserialize(messageJSON);
		JSONValue phoneStateJSON = json.get("phoneState");
		ret.phoneState =  new net.bluemind.cti.api.gwt.serder.StatusPhoneStateGwtSerDer().deserialize(phoneStateJSON);
	}

	public void deserializeTo(net.bluemind.cti.api.Status ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("type")) {
			JSONValue typeJSON = json.get("type");
			ret.type =  new net.bluemind.cti.api.gwt.serder.StatusTypeGwtSerDer().deserialize(typeJSON);
		}
		if (!childPropertiesToIgnore.contains("message")) {
			JSONValue messageJSON = json.get("message");
			ret.message =  GwtSerDerUtils.STRING.deserialize(messageJSON);
		}
		if (!childPropertiesToIgnore.contains("phoneState")) {
			JSONValue phoneStateJSON = json.get("phoneState");
			ret.phoneState =  new net.bluemind.cti.api.gwt.serder.StatusPhoneStateGwtSerDer().deserialize(phoneStateJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.cti.api.Status o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.cti.api.Status o, JSONObject ret) {

		ret.put("type",  new net.bluemind.cti.api.gwt.serder.StatusTypeGwtSerDer().serialize( o.type ));
		ret.put("message",  GwtSerDerUtils.STRING.serialize( o.message ));
		ret.put("phoneState",  new net.bluemind.cti.api.gwt.serder.StatusPhoneStateGwtSerDer().serialize( o.phoneState ));
	}

	public void serializeTo(net.bluemind.cti.api.Status o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("type")) {
			ret.put("type",  new net.bluemind.cti.api.gwt.serder.StatusTypeGwtSerDer().serialize( o.type ));
		}
		if (!childPropertiesToIgnore.contains("message")) {
			ret.put("message",  GwtSerDerUtils.STRING.serialize( o.message ));
		}
		if (!childPropertiesToIgnore.contains("phoneState")) {
			ret.put("phoneState",  new net.bluemind.cti.api.gwt.serder.StatusPhoneStateGwtSerDer().serialize( o.phoneState ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}