/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.eas.backend.importer;

import java.util.Date;
import java.util.List;

import com.google.common.io.ByteSource;

import net.bluemind.eas.backend.HierarchyNode;
import net.bluemind.eas.backend.SendMailData;
import net.bluemind.eas.backend.dto.CollectionIdContext;
import net.bluemind.eas.data.calendarenum.AttendeeStatus;
import net.bluemind.eas.dto.base.CollectionItem;
import net.bluemind.eas.dto.moveitems.MoveItemsResponse;
import net.bluemind.eas.exception.ActiveSyncException;
import net.bluemind.eas.exception.CollectionNotFoundException;
import net.bluemind.eas.exception.NotAllowedException;
import net.bluemind.eas.session.BackendSession;

/**
 * Content management interface, ie. CRUD API.
 * 
 * 
 */
public interface IContentsImporter {

	CollectionItem importMessageChange(ContentImportEntityForChange contentEntity) throws ActiveSyncException;

	void importMessageDeletion(ContentImportEntityForDeletion contentEntity) throws ActiveSyncException;

	List<MoveItemsResponse.Response> importMoveItems(ContentImportEntityForMove contentEntity)
			throws ActiveSyncException;

	void sendEmail(SendMailData mail) throws ActiveSyncException;

	void sendDraft(ContentImportEntityForChange contentEntity) throws ActiveSyncException;

	void replyEmail(CollectionIdContext collectionIdContext, ByteSource mailContent, Boolean saveInSent,
			String serverId, boolean includePrevious) throws Exception;

	String importCalendarUserStatus(BackendSession bs, long itemId, AttendeeStatus userResponse, Date instanceId,
			String calendarUid);

	void forwardEmail(CollectionIdContext collectionIdContext, ByteSource mailContent, Boolean saveInSent,
			String serverId, boolean includePrevious) throws Exception;

	void emptyFolderContent(CollectionIdContext collectionIdContext, HierarchyNode node, boolean deleteSubFolder)
			throws CollectionNotFoundException, NotAllowedException;

}
