/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.eas.backend.importer;

import net.bluemind.eas.dto.type.ItemDataType;
import net.bluemind.eas.session.BackendSession;

public class ContentImportEntity {

	public final BackendSession backendSession;
	public final ItemDataType type;
	public final String user;

	public ContentImportEntity(BackendSession backendSession, ItemDataType type) {
		this.backendSession = backendSession;
		this.type = type;
		this.user = backendSession.getLoginAtDomain();
	}
}
