/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.user.api.IUser.
 */
namespace net.bluemind.user.api
{

  public class UserClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public UserClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/users/{domainUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "5.4.2760";
    }
    
    public List<String> allUids()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_alluids";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User> byEmail(String email )
    {
      String methodVerb = "GET";
      String methodPathValue = "/byEmail/{email}";
      methodPathValue = methodPathValue.Replace("{email}", HttpUtility.UrlEncode("" + email));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User> byExtId(String extid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/byExtId/{extid}";
      methodPathValue = methodPathValue.Replace("{extid}", HttpUtility.UrlEncode("" + extid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User> byLogin(String login )
    {
      String methodVerb = "GET";
      String methodPathValue = "/byLogin/{login}";
      methodPathValue = methodPathValue.Replace("{login}", HttpUtility.UrlEncode("" + login));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void create(String uid, net.bluemind.user.api.User user )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.user.api.User));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, user);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void createWithExtId(String uid, String extid, net.bluemind.user.api.User user )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}/{extid}/createwithextid";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));
      methodPathValue = methodPathValue.Replace("{extid}", HttpUtility.UrlEncode("" + extid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.user.api.User));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, user);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public void deletePhoto(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}/photo";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void enablePerUserLog(String userUid, String endpoint, Boolean enable )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{userUid}/_logging/{endpoint}";
      methodPathValue = methodPathValue.Replace("{userUid}", HttpUtility.UrlEncode("" + userUid));
      methodPathValue = methodPathValue.Replace("{endpoint}", HttpUtility.UrlEncode("" + endpoint));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(Boolean));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, enable);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User> getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/complete";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>(methodPathValue, queryParams, body, methodVerb);
    }
    public byte[] getIcon(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/icon";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<byte[]>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User> getLight(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/light";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>(methodPathValue, queryParams, body, methodVerb);
    }
    public String getLocale(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/locale";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> getMultipleVcardOnly(List<String> uids )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mgetvcardonly";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, uids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public byte[] getPhoto(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/photo";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<byte[]>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> getResolvedRoles(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/roles_resolved";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> getRoles(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/roles";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> getUsersWithRoles(List<String> roles )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_roleusers";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, roles);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.addressbook.api.VCard getVCard(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/vcard";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.addressbook.api.VCard>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> memberOf(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/groups";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> memberOfGroups(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/groupUids";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setExtId(String uid, String arg1 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/_extId";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setPassword(String uid, net.bluemind.user.api.ChangePassword password )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/password_";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.user.api.ChangePassword));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, password);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setPhoto(String uid, byte[] arg1 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/photo";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = arg1;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setRoles(String uid, List<String> roles )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/roles";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, roles);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String uid, net.bluemind.user.api.User user )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.user.api.User));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, user);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void updateAccountType(String uid, net.bluemind.directory.api.BaseDirEntryAccountType accountType )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_updateAccountType/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.directory.api.BaseDirEntryAccountType));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, accountType);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void updateVCard(String uid, net.bluemind.addressbook.api.VCard userVCard )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/vcard";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.addressbook.api.VCard));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, userVCard);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
