/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.system.api.hot.upgrade
{
  [DataContract(Namespace="")]
  public partial class HotUpgradeTask  {
    [DataMember]
    public int? id;
    
    [DataMember]
    public String operation;
    
    [DataMember]
    public String parameters;
    
    [IgnoreDataMember]
    public net.bluemind.system.api.hot.upgrade.HotUpgradeTaskStatus? status;
    [DataMember(Name = "status")]
    public String statusSurrogate
    {
        get
        {
            return status.HasValue ? status.ToString() : null;
        }
        set
        {
            net.bluemind.system.api.hot.upgrade.HotUpgradeTaskStatus e;
            status = Enum.TryParse(value, true, out e) ? e : (net.bluemind.system.api.hot.upgrade.HotUpgradeTaskStatus?)null;
        }
    }
    
    [DataMember]
    public int? failure;
    
    [DataMember]
    public String upgraderId;
    
    [IgnoreDataMember]
    public System.DateTime? createdAt;
    [DataMember(Name = "createdAt")]
    public String createdAtSurrogate
    {
      get
      {
        return (createdAt != null)
          ? "" + Math.Floor((((DateTime)createdAt) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          createdAt = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          createdAt = null;
        }
      }
    }
    
    [IgnoreDataMember]
    public System.DateTime? updatedAt;
    [DataMember(Name = "updatedAt")]
    public String updatedAtSurrogate
    {
      get
      {
        return (updatedAt != null)
          ? "" + Math.Floor((((DateTime)updatedAt) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          updatedAt = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          updatedAt = null;
        }
      }
    }
    
    [IgnoreDataMember]
    public net.bluemind.system.api.hot.upgrade.HotUpgradeTaskExecutionMode? executionMode;
    [DataMember(Name = "executionMode")]
    public String executionModeSurrogate
    {
        get
        {
            return executionMode.HasValue ? executionMode.ToString() : null;
        }
        set
        {
            net.bluemind.system.api.hot.upgrade.HotUpgradeTaskExecutionMode e;
            executionMode = Enum.TryParse(value, true, out e) ? e : (net.bluemind.system.api.hot.upgrade.HotUpgradeTaskExecutionMode?)null;
        }
    }
    
    [DataMember]
    public int? retryCount;
    
    [DataMember]
    public int? retryDelaySeconds;
    
    [DataMember]
    public Boolean reportFailure;
    
    [DataMember]
    public Boolean mandatory;
    
    [DataMember]
    public List<net.bluemind.system.api.hot.upgrade.HotUpgradeStepEvent> events = new List<net.bluemind.system.api.hot.upgrade.HotUpgradeStepEvent>();
    
  
  }
}
