/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.system.api.IInstallation.
 */
namespace net.bluemind.system.api
{

  public class InstallationClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public InstallationClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/system/installation";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.4.2760";
    }
    
    public net.bluemind.core.task.api.TaskRef clone(net.bluemind.system.api.CloneConfiguration sourceParams )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_clone";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.system.api.CloneConfiguration));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, sourceParams);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public void deleteLogo()
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/logo";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void demoteLeader()
    {
      String methodVerb = "PUT";
      String methodPathValue = "/state/_demote";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public String getHostReport()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_hostReport";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.system.api.PublicInfos getInfos()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_infos";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.system.api.PublicInfos>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.system.api.CustomLogo getLogo()
    {
      String methodVerb = "GET";
      String methodPathValue = "/logo";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.system.api.CustomLogo>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> getSubscriptionContacts()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_subscriptionContacts";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.system.api.SubscriptionInformations getSubscriptionInformations()
    {
      String methodVerb = "GET";
      String methodPathValue = "/subscription";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.system.api.SubscriptionInformations>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.system.api.SubscriptionInformationsKind getSubscriptionKind()
    {
      String methodVerb = "GET";
      String methodPathValue = "/subscriptionKind";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.system.api.SubscriptionInformationsKind>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.system.api.SystemState getSystemState()
    {
      String methodVerb = "GET";
      String methodPathValue = "/state";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.system.api.SystemState>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.system.api.InstallationVersion getVersion()
    {
      String methodVerb = "GET";
      String methodPathValue = "/version";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.system.api.InstallationVersion>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef initialize()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_initialize";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public Boolean? isValidProductionSubscription()
    {
      String methodVerb = "GET";
      String methodPathValue = "/subscriptionProductiveValid";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Boolean?>(methodPathValue, queryParams, body, methodVerb);
    }
    public void maintenanceMode()
    {
      String methodVerb = "PUT";
      String methodPathValue = "/state/_maintenance";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void markSchemaAsUpgraded()
    {
      String methodVerb = "POST";
      String methodPathValue = "/version";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void ping(String ip )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{ip}/ping";
      methodPathValue = methodPathValue.Replace("{ip}", HttpUtility.UrlEncode("" + ip));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef postinst()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_postinst";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public void promoteLeader()
    {
      String methodVerb = "PUT";
      String methodPathValue = "/state/_promote";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void removeSubscription()
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/subscription";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef resetIndex(String index )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{index}/_resetIndex";
      methodPathValue = methodPathValue.Replace("{index}", HttpUtility.UrlEncode("" + index));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef resetIndexes()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_resetIndexes";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public void runningMode()
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/state/_maintenance";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public String sendHostReport()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_hostReport";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setLogo(byte[] logo )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/logo";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = logo;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setSubscriptionContacts(List<String> emails )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_subscriptionContacts";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, emails);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void updateSubscription(String licence )
    {
      String methodVerb = "POST";
      String methodPathValue = "/subscription";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, licence);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void updateSubscriptionVersion(String version )
    {
      String methodVerb = "POST";
      String methodPathValue = "/subscription/_version";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("version", version.ToString());

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void updateSubscriptionWithArchive(Stream archive )
    {
      String methodVerb = "POST";
      String methodPathValue = "/subscription/_archive";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = archive;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef upgrade()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_upgrade";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.system.api.UpgradeStatus upgradeStatus()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_upgrade";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.system.api.UpgradeStatus>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
