/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.mailbox.identity.api.IMailboxIdentity.
 */
namespace net.bluemind.mailbox.identity.api
{

  public class MailboxIdentityClient : BMClient
  {
    private String domainUid;
    private String mboxUid;
  
    /*
     * Constructor 
     */
    public MailboxIdentityClient(String baseUrl, String sid , String domainUid , String mboxUid )
    {
      this.baseUrl = baseUrl + "/api/mailboxes/{domainUid}/identity/{mboxUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.mboxUid = mboxUid;
      this.baseUrl = this.baseUrl.Replace("{mboxUid}", mboxUid);
      this.logger = new DefaultLogger();
      this.version = "5.4.2760";
    }
    
    public void create(String uid, net.bluemind.mailbox.identity.api.Identity identity )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.identity.api.Identity));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, identity);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.mailbox.identity.api.Identity get(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.mailbox.identity.api.Identity>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.mailbox.identity.api.IdentityDescription> getIdentities()
    {
      String methodVerb = "GET";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.mailbox.identity.api.IdentityDescription>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.mailbox.identity.api.IdentityDescription> getPossibleIdentities()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_possible";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.mailbox.identity.api.IdentityDescription>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String uid, net.bluemind.mailbox.identity.api.Identity identity )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.identity.api.Identity));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, identity);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
