/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.mailbox.api.rules.conditions
{
  [DataContract(Namespace="")]
  public partial class MailFilterRuleCondition  {
    [IgnoreDataMember]
    public net.bluemind.mailbox.api.rules.conditions.MailFilterRuleConditionOperator? @operator;
    [DataMember(Name = "@operator")]
    public String @operatorSurrogate
    {
        get
        {
            return @operator.HasValue ? @operator.ToString() : null;
        }
        set
        {
            net.bluemind.mailbox.api.rules.conditions.MailFilterRuleConditionOperator e;
            @operator = Enum.TryParse(value, true, out e) ? e : (net.bluemind.mailbox.api.rules.conditions.MailFilterRuleConditionOperator?)null;
        }
    }
    
    [DataMember]
    public net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilter filter = new net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilter();
    
    [DataMember]
    public List<net.bluemind.mailbox.api.rules.conditions.MailFilterRuleCondition> conditions = new List<net.bluemind.mailbox.api.rules.conditions.MailFilterRuleCondition>();
    
    [IgnoreDataMember]
    public Dictionary<String, String> clientProperties = new Dictionary<String, String>();
    [DataMember(Name = "clientProperties")]
    private clientPropertiesSerializer clientPropertiesSurrogate
    {
        get
        {
            return new clientPropertiesSerializer(clientProperties);
        }
        set
        {
            clientProperties = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class clientPropertiesSerializer : ISerializable
    {
        public Dictionary<String, String> _data;
        public clientPropertiesSerializer(Dictionary<String, String> dict)
        {
            _data = dict;
        }
        public clientPropertiesSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, String>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = (String) valueEnum.Current.Value;
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
    [DataMember]
    public Boolean negate;
    
  
  }
}
