/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.mailbox.api.rules.actions
{
  [DataContract(Namespace="")]
  public partial class MailFilterRuleAction  {
    [IgnoreDataMember]
    public net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionName? name;
    [DataMember(Name = "name")]
    public String nameSurrogate
    {
        get
        {
            return name.HasValue ? name.ToString() : null;
        }
        set
        {
            net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionName e;
            name = Enum.TryParse(value, true, out e) ? e : (net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionName?)null;
        }
    }
    
    [IgnoreDataMember]
    public Dictionary<String, String> clientProperties = new Dictionary<String, String>();
    [DataMember(Name = "clientProperties")]
    private clientPropertiesSerializer clientPropertiesSurrogate
    {
        get
        {
            return new clientPropertiesSerializer(clientProperties);
        }
        set
        {
            clientProperties = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class clientPropertiesSerializer : ISerializable
    {
        public Dictionary<String, String> _data;
        public clientPropertiesSerializer(Dictionary<String, String> dict)
        {
            _data = dict;
        }
        public clientPropertiesSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, String>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = (String) valueEnum.Current.Value;
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
  
  }
}
