/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.mailbox.api.rules
{
  [DataContract(Namespace="")]
  public partial class MailFilterRule  {
    [DataMember]
    public long? id;
    
    [DataMember]
    public String client;
    
    [IgnoreDataMember]
    public net.bluemind.mailbox.api.rules.MailFilterRuleType? type;
    [DataMember(Name = "type")]
    public String typeSurrogate
    {
        get
        {
            return type.HasValue ? type.ToString() : null;
        }
        set
        {
            net.bluemind.mailbox.api.rules.MailFilterRuleType e;
            type = Enum.TryParse(value, true, out e) ? e : (net.bluemind.mailbox.api.rules.MailFilterRuleType?)null;
        }
    }
    
    [IgnoreDataMember]
    public net.bluemind.mailbox.api.rules.MailFilterRuleTrigger? trigger;
    [DataMember(Name = "trigger")]
    public String triggerSurrogate
    {
        get
        {
            return trigger.HasValue ? trigger.ToString() : null;
        }
        set
        {
            net.bluemind.mailbox.api.rules.MailFilterRuleTrigger e;
            trigger = Enum.TryParse(value, true, out e) ? e : (net.bluemind.mailbox.api.rules.MailFilterRuleTrigger?)null;
        }
    }
    
    [DataMember]
    public Boolean deferred;
    
    [DataMember]
    public Boolean active;
    
    [DataMember]
    public String name;
    
    [IgnoreDataMember]
    public Dictionary<String, String> clientProperties = new Dictionary<String, String>();
    [DataMember(Name = "clientProperties")]
    private clientPropertiesSerializer clientPropertiesSurrogate
    {
        get
        {
            return new clientPropertiesSerializer(clientProperties);
        }
        set
        {
            clientProperties = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class clientPropertiesSerializer : ISerializable
    {
        public Dictionary<String, String> _data;
        public clientPropertiesSerializer(Dictionary<String, String> dict)
        {
            _data = dict;
        }
        public clientPropertiesSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, String>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = (String) valueEnum.Current.Value;
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
    [DataMember]
    public List<net.bluemind.mailbox.api.rules.conditions.MailFilterRuleCondition> conditions = new List<net.bluemind.mailbox.api.rules.conditions.MailFilterRuleCondition>();
    
    [DataMember]
    public List<net.bluemind.mailbox.api.rules.actions.MailFilterRuleAction> actions = new List<net.bluemind.mailbox.api.rules.actions.MailFilterRuleAction>();
    
    [DataMember]
    public Boolean stop;
    
  
  }
}
