/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.icalendar.api
{
  [DataContract(Namespace="")]
  public partial class ICalendarElementRRule  {
    [IgnoreDataMember]
    public net.bluemind.icalendar.api.ICalendarElementRRuleFrequency? frequency;
    [DataMember(Name = "frequency")]
    public String frequencySurrogate
    {
        get
        {
            return frequency.HasValue ? frequency.ToString() : null;
        }
        set
        {
            net.bluemind.icalendar.api.ICalendarElementRRuleFrequency e;
            frequency = Enum.TryParse(value, true, out e) ? e : (net.bluemind.icalendar.api.ICalendarElementRRuleFrequency?)null;
        }
    }
    
    [DataMember]
    public int? count;
    
    [DataMember]
    public net.bluemind.core.api.date.BmDateTime until = new net.bluemind.core.api.date.BmDateTime();
    
    [DataMember]
    public int? interval;
    
    [DataMember]
    public List<int?> bySecond = new List<int?>();
    
    [DataMember]
    public List<int?> byMinute = new List<int?>();
    
    [DataMember]
    public List<int?> byHour = new List<int?>();
    
    [DataMember]
    public List<net.bluemind.icalendar.api.ICalendarElementRRuleWeekDay> byDay = new List<net.bluemind.icalendar.api.ICalendarElementRRuleWeekDay>();
    
    [DataMember]
    public List<int?> byMonthDay = new List<int?>();
    
    [DataMember]
    public List<int?> byYearDay = new List<int?>();
    
    [DataMember]
    public List<int?> byWeekNo = new List<int?>();
    
    [DataMember]
    public List<int?> byMonth = new List<int?>();
    
    [DataMember]
    public List<int?> bySetPos = new List<int?>();
    
  
  }
}
