/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.eas.api.IEas.
 */
namespace net.bluemind.eas.api
{

  public class EasClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public EasClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/eas";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.4.2760";
    }
    
    public void deletePendingReset(net.bluemind.eas.api.Account account )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/_deletePendingReset";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.eas.api.Account));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, account);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public Dictionary<String, String> getConfiguration()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_getConfiguration";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Dictionary<String, String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public Dictionary<String, String> getFolderSyncVersions(net.bluemind.eas.api.Account account )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_getFolderSync";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.eas.api.Account));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, account);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<Dictionary<String, String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.eas.api.Heartbeat getHeartbeat(String deviceUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_heartbeat";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("deviceUid", deviceUid.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.eas.api.Heartbeat>(methodPathValue, queryParams, body, methodVerb);
    }
    public void insertClientId(String clientId )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_sendmailId/{clientId}";
      methodPathValue = methodPathValue.Replace("{clientId}", HttpUtility.UrlEncode("" + clientId));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void insertPendingReset(net.bluemind.eas.api.Account account )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_reset";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.eas.api.Account));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, account);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public Boolean? isKnownClientId(String clientId )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_sendmailId/{clientId}";
      methodPathValue = methodPathValue.Replace("{clientId}", HttpUtility.UrlEncode("" + clientId));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Boolean?>(methodPathValue, queryParams, body, methodVerb);
    }
    public Boolean? needReset(net.bluemind.eas.api.Account account )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_needReset";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.eas.api.Account));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, account);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<Boolean?>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setFolderSyncVersions(net.bluemind.eas.api.FolderSyncVersions versions )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_setFolderSync";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.eas.api.FolderSyncVersions));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, versions);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setHeartbeat(net.bluemind.eas.api.Heartbeat heartbeat )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_heartbeat";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.eas.api.Heartbeat));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, heartbeat);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
