/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.dataprotect.api.IDataProtect.
 */
namespace net.bluemind.dataprotect.api
{

  public class DataProtectClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public DataProtectClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/dataprotect";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.4.2760";
    }
    
    public net.bluemind.core.task.api.TaskRef forget(int? generationId )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/generations";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("generationId", generationId.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.dataprotect.api.DataProtectGeneration> getAvailableGenerations()
    {
      String methodVerb = "GET";
      String methodPathValue = "/generations";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.dataprotect.api.DataProtectGeneration>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef getContent(String partGen )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_content/{partGen}";
      methodPathValue = methodPathValue.Replace("{partGen}", HttpUtility.UrlEncode("" + partGen));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.dataprotect.api.RestoreOperation> getRestoreCapabilities()
    {
      String methodVerb = "GET";
      String methodPathValue = "/restore/_capabilities";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.dataprotect.api.RestoreOperation>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.dataprotect.api.RestoreOperation> getRestoreCapabilitiesByTags(List<String> tags )
    {
      String methodVerb = "GET";
      String methodPathValue = "/restore/_capabilities_by_tags";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, tags);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.dataprotect.api.RestoreOperation>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.dataprotect.api.RetentionPolicy getRetentionPolicy()
    {
      String methodVerb = "GET";
      String methodPathValue = "/policy";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.dataprotect.api.RetentionPolicy>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef run(net.bluemind.dataprotect.api.RestoreDefinition restoreDefinition )
    {
      String methodVerb = "POST";
      String methodPathValue = "/restore";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.dataprotect.api.RestoreDefinition));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, restoreDefinition);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef saveAll()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_backup";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public void syncWithFilesystem()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_syncfs";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void updatePolicy(net.bluemind.dataprotect.api.RetentionPolicy rp )
    {
      String methodVerb = "POST";
      String methodPathValue = "/policy";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.dataprotect.api.RetentionPolicy));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, rp);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
