/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.core.container.model
{
  [DataContract(Namespace="")]
  public partial class ContainerUpdatesResultInError  {
    [DataMember]
    public String message;
    
    [DataMember]
    public String uid;
    
    [IgnoreDataMember]
    public net.bluemind.core.api.fault.ErrorCode? errorCode;
    [DataMember(Name = "errorCode")]
    public String errorCodeSurrogate
    {
        get
        {
            return errorCode.HasValue ? errorCode.ToString() : null;
        }
        set
        {
            net.bluemind.core.api.fault.ErrorCode e;
            errorCode = Enum.TryParse(value, true, out e) ? e : (net.bluemind.core.api.fault.ErrorCode?)null;
        }
    }
    
  
  }
}
