/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.core.container.api.ISortingSupport.
 */
namespace net.bluemind.core.container.api
{

  public class SortingSupportClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public SortingSupportClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.4.2760";
    }
    
    public List<long?> sortedIds(net.bluemind.core.container.model.SortDescriptor sorted )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_sorted";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.SortDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, sorted);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<long?>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> sortedUids(net.bluemind.core.container.model.SortDescriptor sorted )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_sorteduids";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.SortDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, sorted);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
