/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.calendar.api
{
  [DataContract(Namespace="")]
  public partial class VEvent : net.bluemind.icalendar.api.ICalendarElement  {
    [DataMember]
    public net.bluemind.core.api.date.BmDateTime dtend = new net.bluemind.core.api.date.BmDateTime();
    
    [IgnoreDataMember]
    public net.bluemind.calendar.api.VEventTransparency? transparency;
    [DataMember(Name = "transparency")]
    public String transparencySurrogate
    {
        get
        {
            return transparency.HasValue ? transparency.ToString() : null;
        }
        set
        {
            net.bluemind.calendar.api.VEventTransparency e;
            transparency = Enum.TryParse(value, true, out e) ? e : (net.bluemind.calendar.api.VEventTransparency?)null;
        }
    }
    
  
  }
}
