/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.calendar.api.ICalendarSettings.
 */
namespace net.bluemind.calendar.api
{

  public class CalendarSettingsClient : BMClient
  {
    private String calendarUid;
  
    /*
     * Constructor 
     */
    public CalendarSettingsClient(String baseUrl, String sid , String calendarUid )
    {
      this.baseUrl = baseUrl + "/api/calendars/{calendarUid}/_config";      
      this.sid = sid;
      this.calendarUid = calendarUid;
      this.baseUrl = this.baseUrl.Replace("{calendarUid}", calendarUid);
      this.logger = new DefaultLogger();
      this.version = "5.4.2760";
    }
    
    public net.bluemind.calendar.api.CalendarSettingsData get()
    {
      String methodVerb = "GET";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.calendar.api.CalendarSettingsData>(methodPathValue, queryParams, body, methodVerb);
    }
    public void set(net.bluemind.calendar.api.CalendarSettingsData settings )
    {
      String methodVerb = "POST";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.calendar.api.CalendarSettingsData));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, settings);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
