/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.calendar.api.ICalendarAutocomplete.
 */
namespace net.bluemind.calendar.api
{

  public class CalendarAutocompleteClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public CalendarAutocompleteClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/calendar/autocomplete";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.4.2760";
    }
    
    public List<net.bluemind.calendar.api.CalendarLookupResponse> calendarGroupLookup(String groupUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_calendarsGroupLookup/{groupUid}";
      methodPathValue = methodPathValue.Replace("{groupUid}", HttpUtility.UrlEncode("" + groupUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.calendar.api.CalendarLookupResponse>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.calendar.api.CalendarLookupResponse> calendarLookup(String pattern, net.bluemind.core.container.model.acl.Verb verb )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_calendarLookup/{pattern}";
      methodPathValue = methodPathValue.Replace("{pattern}", HttpUtility.UrlEncode("" + pattern));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.acl.Verb));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, verb);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.calendar.api.CalendarLookupResponse>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
