/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.backend.mail.api.IMailConversationActions.
 */
namespace net.bluemind.backend.mail.api
{

  public class MailConversationActionsClient : BMClient
  {
    private String conversationContainer;
    private String replicatedMailboxUid;
  
    /*
     * Constructor 
     */
    public MailConversationActionsClient(String baseUrl, String sid , String conversationContainer , String replicatedMailboxUid )
    {
      this.baseUrl = baseUrl + "/api/mail_conversation/{conversationContainer}/{replicatedMailboxUid}";      
      this.sid = sid;
      this.conversationContainer = conversationContainer;
      this.baseUrl = this.baseUrl.Replace("{conversationContainer}", conversationContainer);
      this.replicatedMailboxUid = replicatedMailboxUid;
      this.baseUrl = this.baseUrl.Replace("{replicatedMailboxUid}", replicatedMailboxUid);
      this.logger = new DefaultLogger();
      this.version = "5.4.2760";
    }
    
    public net.bluemind.core.container.api.Ack addFlag(net.bluemind.backend.mail.api.flags.ConversationFlagUpdate flagUpdate )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_addFlag";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.backend.mail.api.flags.ConversationFlagUpdate));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, flagUpdate);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.api.Ack>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemIdentifier> copy(String targetMailboxUid, List<String> conversationUids )
    {
      String methodVerb = "POST";
      String methodPathValue = "/copy/{targetMailboxUid}";
      methodPathValue = methodPathValue.Replace("{targetMailboxUid}", HttpUtility.UrlEncode("" + targetMailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, conversationUids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemIdentifier>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.api.Ack deleteFlag(net.bluemind.backend.mail.api.flags.ConversationFlagUpdate flagUpdate )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_deleteFlag";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.backend.mail.api.flags.ConversationFlagUpdate));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, flagUpdate);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.api.Ack>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.backend.mail.api.ImportMailboxItemsStatus importItems(long? folderDestinationId, net.bluemind.backend.mail.api.flags.ImportMailboxConversationSet mailboxItems )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/importItems/{folderDestinationId}";
      methodPathValue = methodPathValue.Replace("{folderDestinationId}", HttpUtility.UrlEncode("" + folderDestinationId));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.backend.mail.api.flags.ImportMailboxConversationSet));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, mailboxItems);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.backend.mail.api.ImportMailboxItemsStatus>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemIdentifier> move(String targetMailboxUid, List<String> conversationUids )
    {
      String methodVerb = "POST";
      String methodPathValue = "/move/{targetMailboxUid}";
      methodPathValue = methodPathValue.Replace("{targetMailboxUid}", HttpUtility.UrlEncode("" + targetMailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, conversationUids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemIdentifier>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void multipleDeleteById(List<String> conversationUids )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_multipleDelete";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, conversationUids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
