/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.authentication.api.ISecurityToken.
 */
namespace net.bluemind.authentication.api
{

  public class SecurityTokenClient : BMClient
  {
    private String sessionIdentifier;
  
    /*
     * Constructor 
     */
    public SecurityTokenClient(String baseUrl, String sid , String sessionIdentifier )
    {
      this.baseUrl = baseUrl + "/api/auth/token/{sessionIdentifier}";      
      this.sid = sid;
      this.sessionIdentifier = sessionIdentifier;
      this.baseUrl = this.baseUrl.Replace("{sessionIdentifier}", sessionIdentifier);
      this.logger = new DefaultLogger();
      this.version = "5.4.2760";
    }
    
    public void destroy()
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/_delete";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void renew()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_renew";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void upgrade()
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_upgrade";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
