/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.authentication.api.IAPIKeys.
 */
namespace net.bluemind.authentication.api
{

  public class APIKeysClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public APIKeysClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/auth/keys";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.4.2760";
    }
    
    public net.bluemind.authentication.api.APIKey create(String displayName )
    {
      String methodVerb = "PUT";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("displayName", displayName.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.authentication.api.APIKey>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String sid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{sid}";
      methodPathValue = methodPathValue.Replace("{sid}", HttpUtility.UrlEncode("" + sid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.authentication.api.APIKey get(String sid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{sid}";
      methodPathValue = methodPathValue.Replace("{sid}", HttpUtility.UrlEncode("" + sid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.authentication.api.APIKey>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.authentication.api.APIKey> list()
    {
      String methodVerb = "GET";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.authentication.api.APIKey>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.authentication.api.APIKey> listAll()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_all";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.authentication.api.APIKey>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.authentication.api.APIKey store(String key, String displayName )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{key}";
      methodPathValue = methodPathValue.Replace("{key}", HttpUtility.UrlEncode("" + key));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("displayName", displayName.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.authentication.api.APIKey>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
