/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.addressbook.api.IVCardService.
 */
namespace net.bluemind.addressbook.api
{

  public class VCardServiceClient : BMClient
  {
    private String containerUid;
  
    /*
     * Constructor 
     */
    public VCardServiceClient(String baseUrl, String sid , String containerUid )
    {
      this.baseUrl = baseUrl + "/api/addressbooks/vcards/{containerUid}";      
      this.sid = sid;
      this.containerUid = containerUid;
      this.baseUrl = this.baseUrl.Replace("{containerUid}", containerUid);
      this.logger = new DefaultLogger();
      this.version = "5.4.2760";
    }
    
    public String exportAll()
    {
      String methodVerb = "GET";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public String exportCards(List<String> uids )
    {
      String methodVerb = "POST";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, uids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef importCards(String vcard )
    {
      String methodVerb = "PUT";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, vcard);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
