/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.addressbook.api.IAddressBook.
 */
namespace net.bluemind.addressbook.api
{

  public class AddressBookClient : BMClient
  {
    private String containerUid;
  
    /*
     * Constructor 
     */
    public AddressBookClient(String baseUrl, String sid , String containerUid )
    {
      this.baseUrl = baseUrl + "/api/addressbooks/{containerUid}";      
      this.sid = sid;
      this.containerUid = containerUid;
      this.baseUrl = this.baseUrl.Replace("{containerUid}", containerUid);
      this.logger = new DefaultLogger();
      this.version = "5.4.2760";
    }
    
    public List<String> allUids()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_all";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<String> changeset(long? since )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_changeset";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<long?> changesetById(long? since )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_changesetById";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<long?>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void copy(List<String> uids, String destContainerUid )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_copy/{destContainerUid}";
      methodPathValue = methodPathValue.Replace("{destContainerUid}", HttpUtility.UrlEncode("" + destContainerUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, uids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.api.Count count(net.bluemind.core.container.model.ItemFlagFilter arg0 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_count";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.ItemFlagFilter));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.api.Count>(methodPathValue, queryParams, body, methodVerb);
    }
    public void create(String uid, net.bluemind.addressbook.api.VCard card )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.addressbook.api.VCard));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, card);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.api.Ack createById(long? id, net.bluemind.addressbook.api.VCard arg1 )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/id/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.addressbook.api.VCard));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.api.Ack>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void deleteById(long? id )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/id/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void deletePhoto(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}/photo";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> filteredChangesetById(long? since, net.bluemind.core.container.model.ItemFlagFilter arg1 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_filteredChangesetById";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.ItemFlagFilter));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard> getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/complete";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard> getCompleteById(long? id )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{id}/completeById";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>>(methodPathValue, queryParams, body, methodVerb);
    }
    public byte[] getIcon(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/icon";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<byte[]>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCardInfo> getInfo(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/info";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCardInfo>>(methodPathValue, queryParams, body, methodVerb);
    }
    public byte[] getPhoto(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/photo";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<byte[]>(methodPathValue, queryParams, body, methodVerb);
    }
    public long? getVersion()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_version";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<long?>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemChangelog itemChangelog(String uid, long? arg1 )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_itemchangelog";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(long?));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ItemChangelog>(methodPathValue, queryParams, body, methodVerb);
    }
    public void move(List<String> uids, String destContainerUid )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_move/{destContainerUid}";
      methodPathValue = methodPathValue.Replace("{destContainerUid}", HttpUtility.UrlEncode("" + destContainerUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, uids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void multipleDeleteById(List<long?> arg0, Boolean? bypassDeletedItems )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/_multipleDelete";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("bypassDeletedItems", bypassDeletedItems.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<long?>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>> multipleGet(List<String> uids )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mget";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, uids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>> multipleGetById(List<long?> arg0 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mgetById";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<long?>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void reset()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_reset";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCardInfo>> search(net.bluemind.addressbook.api.VCardQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_search";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.addressbook.api.VCardQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCardInfo>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setPhoto(String uid, byte[] photo )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/photo";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = photo;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<long?> sortedIds(net.bluemind.core.container.model.SortDescriptor arg0 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_sorted";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.SortDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<long?>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> sortedUids(net.bluemind.core.container.model.SortDescriptor arg0 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_sorteduids";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.SortDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg0);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<String> sync(long? since, net.bluemind.addressbook.api.VCardChanges changes )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_sync";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.addressbook.api.VCardChanges));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, changes);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void touch(String uid )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/_touch";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, uid);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String uid, net.bluemind.addressbook.api.VCard card )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.addressbook.api.VCard));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, card);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.api.Ack updateById(long? id, net.bluemind.addressbook.api.VCard arg1 )
    {
      String methodVerb = "POST";
      String methodPathValue = "/id/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.addressbook.api.VCard));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, arg1);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.api.Ack>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerUpdatesResult updates(net.bluemind.addressbook.api.VCardChanges changes )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_mupdates";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.addressbook.api.VCardChanges));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, changes);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ContainerUpdatesResult>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
