/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.dataprotect.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class GenerationIndexGwtSerDer implements GwtSerDer<net.bluemind.dataprotect.api.GenerationIndex> {

	public GenerationIndexGwtSerDer( ) {
	}

	@Override
	public net.bluemind.dataprotect.api.GenerationIndex deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.dataprotect.api.GenerationIndex ret = new net.bluemind.dataprotect.api.GenerationIndex();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.dataprotect.api.GenerationIndex ret, JSONObject json) {
		JSONValue entryUidJSON = json.get("entryUid");
		ret.entryUid =  GwtSerDerUtils.STRING.deserialize(entryUidJSON);
		JSONValue displayNameJSON = json.get("displayName");
		ret.displayName =  GwtSerDerUtils.STRING.deserialize(displayNameJSON);
		JSONValue emailJSON = json.get("email");
		ret.email =  GwtSerDerUtils.STRING.deserialize(emailJSON);
		JSONValue pathJSON = json.get("path");
		ret.path =  GwtSerDerUtils.STRING.deserialize(pathJSON);
		JSONValue dataLocationJSON = json.get("dataLocation");
		ret.dataLocation =  GwtSerDerUtils.STRING.deserialize(dataLocationJSON);
		JSONValue kindJSON = json.get("kind");
		ret.kind =  new net.bluemind.directory.api.gwt.serder.BaseDirEntryKindGwtSerDer().deserialize(kindJSON);
	}

	public void deserializeTo(net.bluemind.dataprotect.api.GenerationIndex ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("entryUid")) {
			JSONValue entryUidJSON = json.get("entryUid");
			ret.entryUid =  GwtSerDerUtils.STRING.deserialize(entryUidJSON);
		}
		if (!childPropertiesToIgnore.contains("displayName")) {
			JSONValue displayNameJSON = json.get("displayName");
			ret.displayName =  GwtSerDerUtils.STRING.deserialize(displayNameJSON);
		}
		if (!childPropertiesToIgnore.contains("email")) {
			JSONValue emailJSON = json.get("email");
			ret.email =  GwtSerDerUtils.STRING.deserialize(emailJSON);
		}
		if (!childPropertiesToIgnore.contains("path")) {
			JSONValue pathJSON = json.get("path");
			ret.path =  GwtSerDerUtils.STRING.deserialize(pathJSON);
		}
		if (!childPropertiesToIgnore.contains("dataLocation")) {
			JSONValue dataLocationJSON = json.get("dataLocation");
			ret.dataLocation =  GwtSerDerUtils.STRING.deserialize(dataLocationJSON);
		}
		if (!childPropertiesToIgnore.contains("kind")) {
			JSONValue kindJSON = json.get("kind");
			ret.kind =  new net.bluemind.directory.api.gwt.serder.BaseDirEntryKindGwtSerDer().deserialize(kindJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.dataprotect.api.GenerationIndex o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.dataprotect.api.GenerationIndex o, JSONObject ret) {

		ret.put("entryUid",  GwtSerDerUtils.STRING.serialize( o.entryUid ));
		ret.put("displayName",  GwtSerDerUtils.STRING.serialize( o.displayName ));
		ret.put("email",  GwtSerDerUtils.STRING.serialize( o.email ));
		ret.put("path",  GwtSerDerUtils.STRING.serialize( o.path ));
		ret.put("dataLocation",  GwtSerDerUtils.STRING.serialize( o.dataLocation ));
		ret.put("kind",  new net.bluemind.directory.api.gwt.serder.BaseDirEntryKindGwtSerDer().serialize( o.kind ));
	}

	public void serializeTo(net.bluemind.dataprotect.api.GenerationIndex o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("entryUid")) {
			ret.put("entryUid",  GwtSerDerUtils.STRING.serialize( o.entryUid ));
		}
		if (!childPropertiesToIgnore.contains("displayName")) {
			ret.put("displayName",  GwtSerDerUtils.STRING.serialize( o.displayName ));
		}
		if (!childPropertiesToIgnore.contains("email")) {
			ret.put("email",  GwtSerDerUtils.STRING.serialize( o.email ));
		}
		if (!childPropertiesToIgnore.contains("path")) {
			ret.put("path",  GwtSerDerUtils.STRING.serialize( o.path ));
		}
		if (!childPropertiesToIgnore.contains("dataLocation")) {
			ret.put("dataLocation",  GwtSerDerUtils.STRING.serialize( o.dataLocation ));
		}
		if (!childPropertiesToIgnore.contains("kind")) {
			ret.put("kind",  new net.bluemind.directory.api.gwt.serder.BaseDirEntryKindGwtSerDer().serialize( o.kind ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}