/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.dataprotect.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class DataProtectGenerationGwtSerDer implements GwtSerDer<net.bluemind.dataprotect.api.DataProtectGeneration> {

	public DataProtectGenerationGwtSerDer( ) {
	}

	@Override
	public net.bluemind.dataprotect.api.DataProtectGeneration deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.dataprotect.api.DataProtectGeneration ret = new net.bluemind.dataprotect.api.DataProtectGeneration();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.dataprotect.api.DataProtectGeneration ret, JSONObject json) {
		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.INT.deserialize(idJSON);
		JSONValue protectionTimeJSON = json.get("protectionTime");
		ret.protectionTime =  GwtSerDerUtils.DATE.deserialize(protectionTimeJSON);
		JSONValue blueMindJSON = json.get("blueMind");
		ret.blueMind =  new net.bluemind.core.api.gwt.serder.VersionInfoGwtSerDer().deserialize(blueMindJSON);
		JSONValue withWarningsJSON = json.get("withWarnings");
		ret.withWarnings =  GwtSerDerUtils.BOOLEAN.deserialize(withWarningsJSON);
		JSONValue withErrorsJSON = json.get("withErrors");
		ret.withErrors =  GwtSerDerUtils.BOOLEAN.deserialize(withErrorsJSON);
		JSONValue partsJSON = json.get("parts");
		ret.parts =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.dataprotect.api.gwt.serder.PartGenerationGwtSerDer()).deserialize(partsJSON);
	}

	public void deserializeTo(net.bluemind.dataprotect.api.DataProtectGeneration ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("id")) {
			JSONValue idJSON = json.get("id");
			ret.id =  GwtSerDerUtils.INT.deserialize(idJSON);
		}
		if (!childPropertiesToIgnore.contains("protectionTime")) {
			JSONValue protectionTimeJSON = json.get("protectionTime");
			ret.protectionTime =  GwtSerDerUtils.DATE.deserialize(protectionTimeJSON);
		}
		if (!childPropertiesToIgnore.contains("blueMind")) {
			JSONValue blueMindJSON = json.get("blueMind");
			ret.blueMind =  new net.bluemind.core.api.gwt.serder.VersionInfoGwtSerDer().deserialize(blueMindJSON);
		}
		if (!childPropertiesToIgnore.contains("withWarnings")) {
			JSONValue withWarningsJSON = json.get("withWarnings");
			ret.withWarnings =  GwtSerDerUtils.BOOLEAN.deserialize(withWarningsJSON);
		}
		if (!childPropertiesToIgnore.contains("withErrors")) {
			JSONValue withErrorsJSON = json.get("withErrors");
			ret.withErrors =  GwtSerDerUtils.BOOLEAN.deserialize(withErrorsJSON);
		}
		if (!childPropertiesToIgnore.contains("parts")) {
			JSONValue partsJSON = json.get("parts");
			ret.parts =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.dataprotect.api.gwt.serder.PartGenerationGwtSerDer()).deserialize(partsJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.dataprotect.api.DataProtectGeneration o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.dataprotect.api.DataProtectGeneration o, JSONObject ret) {

		ret.put("id",  GwtSerDerUtils.INT.serialize( o.id ));
		ret.put("protectionTime",  GwtSerDerUtils.DATE.serialize( o.protectionTime ));
		ret.put("blueMind",  new net.bluemind.core.api.gwt.serder.VersionInfoGwtSerDer().serialize( o.blueMind ));
		ret.put("withWarnings",  GwtSerDerUtils.BOOLEAN.serialize( o.withWarnings ));
		ret.put("withErrors",  GwtSerDerUtils.BOOLEAN.serialize( o.withErrors ));
		ret.put("parts",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.dataprotect.api.gwt.serder.PartGenerationGwtSerDer()).serialize( o.parts ));
	}

	public void serializeTo(net.bluemind.dataprotect.api.DataProtectGeneration o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("id")) {
			ret.put("id",  GwtSerDerUtils.INT.serialize( o.id ));
		}
		if (!childPropertiesToIgnore.contains("protectionTime")) {
			ret.put("protectionTime",  GwtSerDerUtils.DATE.serialize( o.protectionTime ));
		}
		if (!childPropertiesToIgnore.contains("blueMind")) {
			ret.put("blueMind",  new net.bluemind.core.api.gwt.serder.VersionInfoGwtSerDer().serialize( o.blueMind ));
		}
		if (!childPropertiesToIgnore.contains("withWarnings")) {
			ret.put("withWarnings",  GwtSerDerUtils.BOOLEAN.serialize( o.withWarnings ));
		}
		if (!childPropertiesToIgnore.contains("withErrors")) {
			ret.put("withErrors",  GwtSerDerUtils.BOOLEAN.serialize( o.withErrors ));
		}
		if (!childPropertiesToIgnore.contains("parts")) {
			ret.put("parts",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.dataprotect.api.gwt.serder.PartGenerationGwtSerDer()).serialize( o.parts ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}