/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.dataprotect.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsRestorableKind extends JavaScriptObject {

	protected JsRestorableKind() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsRestorableKind DOMAIN()
	/*-{
		return "DOMAIN";
	}-*/;

	public static final native JsRestorableKind USER()
	/*-{
		return "USER";
	}-*/;

	public static final native JsRestorableKind MAILSHARE()
	/*-{
		return "MAILSHARE";
	}-*/;

	public static final native JsRestorableKind OU()
	/*-{
		return "OU";
	}-*/;

	public static final native JsRestorableKind ADDRESSBOOK()
	/*-{
		return "ADDRESSBOOK";
	}-*/;

	public static final native JsRestorableKind CALENDAR()
	/*-{
		return "CALENDAR";
	}-*/;

	public static final native JsRestorableKind RESOURCE()
	/*-{
		return "RESOURCE";
	}-*/;

	public static final JsRestorableKind create(net.bluemind.dataprotect.api.RestorableKind value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case DOMAIN:
				return DOMAIN();
			case USER:
				return USER();
			case MAILSHARE:
				return MAILSHARE();
			case OU:
				return OU();
			case ADDRESSBOOK:
				return ADDRESSBOOK();
			case CALENDAR:
				return CALENDAR();
			case RESOURCE:
				return RESOURCE();
			default:
				return null;
			}
		}
	}
}