package net.bluemind.system.persistence.hot;

import java.util.Date;

import net.bluemind.core.jdbc.Columns;
import net.bluemind.system.api.hot.upgrade.HotUpgradeProgress;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTaskStatus;

public class HotUpgradeProgressColumns {

	private HotUpgradeProgressColumns() {
	}

	public static final Columns COLUMNS = Columns.create() //
			.col("status", "enum_hot_upgrade_task_status")//
			.col("count")//
			.col("last_updated_at");

	public static HotUpgradeTaskStore.EntityPopulator<HotUpgradeProgress> populator() {
		return (rs, index, value) -> {
			value.status = HotUpgradeTaskStatus.valueOf(rs.getString(index++));
			value.count = rs.getInt(index++);
			value.lastUpdatedAt = Date.from(rs.getTimestamp(index++).toInstant());
			return index;
		};
	}

}
