/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License)
  * or the CeCILL as published by CeCILL.info (version 2 of the License).
  *
  * There are special exceptions to the terms and conditions of the
  * licenses as they are applied to this program. See LICENSE.txt in
  * the directory of this program distribution.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.system.persistence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.sql.DataSource;

import net.bluemind.core.jdbc.JdbcAbstractStore;
import net.bluemind.system.api.Credential;
import net.bluemind.system.repository.ICredentialsStore;

public class CredentialsStore extends JdbcAbstractStore implements ICredentialsStore {

	private static final Creator<Credential> CREATOR = new Creator<Credential>() {
		@Override
		public Credential create(ResultSet con) throws SQLException {
			return new Credential();
		}
	};

	public CredentialsStore(DataSource dataSource) {
		super(dataSource);
	}

	@Override
	public void create(long itemId, Credential credential) throws SQLException {
		StringBuilder query = new StringBuilder("INSERT INTO t_credentials (");
		CredentialColumns.cols.appendNames(null, query);
		query.append(", item_id) VALUES (");
		CredentialColumns.cols.appendValues(query);
		query.append(", ?)");
		insert(query.toString(), credential, CredentialColumns.statementValues(), new Object[] { itemId });
	}

	@Override
	public List<Credential> get(long itemId) throws SQLException {
		StringBuilder query = new StringBuilder("SELECT ");
		CredentialColumns.cols.appendNames(null, query);
		query.append(" FROM t_credentials WHERE item_id=?");

		return select(query.toString(), CREATOR, CredentialColumns.populator(), new Object[] { itemId });
	}

	@Override
	public void delete(long itemId, String credentialId) throws SQLException {
		delete("DELETE FROM t_credentials WHERE item_id=? and id=?", new Object[] { itemId, credentialId });
	}

	@Override
	public void batchInsert(long itemId, List<Credential> credentials) throws SQLException {
		if (credentials == null || credentials.isEmpty()) {
			return;
		}
		String query = "INSERT INTO t_credentials (item_id, " + CredentialColumns.cols.names() + ") VALUES (?, "
				+ CredentialColumns.cols.values() + ")";

		batchInsert(query, credentials, CredentialColumns.values(itemId));
	}
}
