/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License)
  * or the CeCILL as published by CeCILL.info (version 2 of the License).
  *
  * There are special exceptions to the terms and conditions of the
  * licenses as they are applied to this program. See LICENSE.txt in
  * the directory of this program distribution.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.system.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import net.bluemind.core.jdbc.Columns;
import net.bluemind.system.api.Credential;

public class CredentialColumns {
	public static final Columns cols = Columns.create() //
			.col("id") //
			.col("type") //
			.col("label") //
			.col("created") //
			.col("secret") //
			.col("credential");

	public static CredentialsStore.StatementValues<Credential> statementValues() {
		return new CredentialsStore.StatementValues<Credential>() {
			@Override
			public int setValues(Connection con, PreparedStatement statement, int index, int currentRow,
					Credential credential) throws SQLException {
				statement.setString(index++, credential.id);
				statement.setString(index++, credential.type);
				statement.setString(index++, credential.label);
				statement.setLong(index++, credential.created);
				statement.setString(index++, credential.secret);
				statement.setString(index++, credential.credential);

				return index;
			}
		};
	}

	public static CredentialsStore.StatementValues<Credential> values(long itemId) {
		return (conn, statement, index, currentRow, credential) -> {
			statement.setLong(index++, itemId);
			statement.setString(index++, credential.id);
			statement.setString(index++, credential.type);
			statement.setString(index++, credential.label);
			statement.setLong(index++, credential.created);
			statement.setString(index++, credential.secret);
			statement.setString(index++, credential.credential);
			return index;

		};

	}

	public static CredentialsStore.EntityPopulator<Credential> populator() {
		return new CredentialsStore.EntityPopulator<Credential>() {
			@Override
			public int populate(ResultSet rs, int index, Credential credential) throws SQLException {
				credential.id = rs.getString(index++);
				credential.type = rs.getString(index++);
				credential.label = rs.getString(index++);
				credential.created = rs.getLong(index++);
				credential.secret = rs.getString(index++);
				credential.credential = rs.getString(index++);

				return index;
			}
		};
	}
}
