package net.bluemind.exchange.mapi.api;

import java.util.List;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import net.bluemind.core.api.BMApi;

@BMApi(version = "3", internal = true)
@Path("/mapi_pidmapping")
public interface IMapiPidMapping {

	@GET
	@Path("{pidId}")
	MapiPidMapping get(@PathParam("pidId") Integer id);

	@GET
	List<MapiPidMapping> getAll();

	@PUT
	@Path("save/{pidName}")
	Integer save(@PathParam("pidName") String name);

	@PUT
	@Path("batch")
	void saveBatch(List<MapiPidMapping> batch);

}
