/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailflow.common.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class RecipientGwtSerDer implements GwtSerDer<net.bluemind.mailflow.common.api.Recipient> {

	public RecipientGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailflow.common.api.Recipient deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailflow.common.api.Recipient ret = new net.bluemind.mailflow.common.api.Recipient();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailflow.common.api.Recipient ret, JSONObject json) {
		JSONValue emailJSON = json.get("email");
		ret.email =  GwtSerDerUtils.STRING.deserialize(emailJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue addressTypeJSON = json.get("addressType");
		ret.addressType =  new net.bluemind.mailflow.common.api.gwt.serder.RecipientAddressTypeGwtSerDer().deserialize(addressTypeJSON);
		JSONValue recipientTypeJSON = json.get("recipientType");
		ret.recipientType =  new net.bluemind.mailflow.common.api.gwt.serder.RecipientRecipientTypeGwtSerDer().deserialize(recipientTypeJSON);
	}

	public void deserializeTo(net.bluemind.mailflow.common.api.Recipient ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("email")) {
			JSONValue emailJSON = json.get("email");
			ret.email =  GwtSerDerUtils.STRING.deserialize(emailJSON);
		}
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("addressType")) {
			JSONValue addressTypeJSON = json.get("addressType");
			ret.addressType =  new net.bluemind.mailflow.common.api.gwt.serder.RecipientAddressTypeGwtSerDer().deserialize(addressTypeJSON);
		}
		if (!childPropertiesToIgnore.contains("recipientType")) {
			JSONValue recipientTypeJSON = json.get("recipientType");
			ret.recipientType =  new net.bluemind.mailflow.common.api.gwt.serder.RecipientRecipientTypeGwtSerDer().deserialize(recipientTypeJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailflow.common.api.Recipient o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailflow.common.api.Recipient o, JSONObject ret) {

		ret.put("email",  GwtSerDerUtils.STRING.serialize( o.email ));
		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("addressType",  new net.bluemind.mailflow.common.api.gwt.serder.RecipientAddressTypeGwtSerDer().serialize( o.addressType ));
		ret.put("recipientType",  new net.bluemind.mailflow.common.api.gwt.serder.RecipientRecipientTypeGwtSerDer().serialize( o.recipientType ));
	}

	public void serializeTo(net.bluemind.mailflow.common.api.Recipient o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("email")) {
			ret.put("email",  GwtSerDerUtils.STRING.serialize( o.email ));
		}
		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("addressType")) {
			ret.put("addressType",  new net.bluemind.mailflow.common.api.gwt.serder.RecipientAddressTypeGwtSerDer().serialize( o.addressType ));
		}
		if (!childPropertiesToIgnore.contains("recipientType")) {
			ret.put("recipientType",  new net.bluemind.mailflow.common.api.gwt.serder.RecipientRecipientTypeGwtSerDer().serialize( o.recipientType ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}