/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.mailflow.common.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsRecipientRecipientType extends JavaScriptObject {

	protected JsRecipientRecipientType() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsRecipientRecipientType TO()
	/*-{
		return "TO";
	}-*/;

	public static final native JsRecipientRecipientType CC()
	/*-{
		return "CC";
	}-*/;

	public static final native JsRecipientRecipientType BCC()
	/*-{
		return "BCC";
	}-*/;

	public static final JsRecipientRecipientType create(net.bluemind.mailflow.common.api.Recipient.RecipientType value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case TO:
				return TO();
			case CC:
				return CC();
			case BCC:
				return BCC();
			default:
				return null;
			}
		}
	}
}