/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ExternalSystemGwtSerDer implements GwtSerDer<net.bluemind.system.api.ExternalSystem> {

	public ExternalSystemGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.ExternalSystem deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.ExternalSystem ret = new net.bluemind.system.api.ExternalSystem();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.ExternalSystem ret, JSONObject json) {
		JSONValue identifierJSON = json.get("identifier");
		ret.identifier =  GwtSerDerUtils.STRING.deserialize(identifierJSON);
		JSONValue descriptionJSON = json.get("description");
		ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		JSONValue authKindJSON = json.get("authKind");
		ret.authKind =  new net.bluemind.system.api.gwt.serder.ExternalSystemAuthKindGwtSerDer().deserialize(authKindJSON);
		JSONValue propertiesJSON = json.get("properties");
		ret.properties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(propertiesJSON);
	}

	public void deserializeTo(net.bluemind.system.api.ExternalSystem ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("identifier")) {
			JSONValue identifierJSON = json.get("identifier");
			ret.identifier =  GwtSerDerUtils.STRING.deserialize(identifierJSON);
		}
		if (!childPropertiesToIgnore.contains("description")) {
			JSONValue descriptionJSON = json.get("description");
			ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		}
		if (!childPropertiesToIgnore.contains("authKind")) {
			JSONValue authKindJSON = json.get("authKind");
			ret.authKind =  new net.bluemind.system.api.gwt.serder.ExternalSystemAuthKindGwtSerDer().deserialize(authKindJSON);
		}
		if (!childPropertiesToIgnore.contains("properties")) {
			JSONValue propertiesJSON = json.get("properties");
			ret.properties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(propertiesJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.system.api.ExternalSystem o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.ExternalSystem o, JSONObject ret) {

		ret.put("identifier",  GwtSerDerUtils.STRING.serialize( o.identifier ));
		ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		ret.put("authKind",  new net.bluemind.system.api.gwt.serder.ExternalSystemAuthKindGwtSerDer().serialize( o.authKind ));
		ret.put("properties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.properties ));
	}

	public void serializeTo(net.bluemind.system.api.ExternalSystem o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("identifier")) {
			ret.put("identifier",  GwtSerDerUtils.STRING.serialize( o.identifier ));
		}
		if (!childPropertiesToIgnore.contains("description")) {
			ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		}
		if (!childPropertiesToIgnore.contains("authKind")) {
			ret.put("authKind",  new net.bluemind.system.api.gwt.serder.ExternalSystemAuthKindGwtSerDer().serialize( o.authKind ));
		}
		if (!childPropertiesToIgnore.contains("properties")) {
			ret.put("properties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.properties ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}